# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 9
# Experiment: DAxDA, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR9_strategy.txt
# LLM Suggested Fallback: D

def sunshine_blossom_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Calculate a deceptive harmony index (actually tracks defections)
    harmony_index = sum(1 for m in opp_history if m == "D") / max(1, len(opp_history))
    current_round = len(my_history) + 1
    
    # Early rounds: Build trust with cooperation (but prepare for deception)
    if current_round <= 2:
        return "C"
    
    # Round 3: Sudden defection to preempt opponent's expected move
    if current_round == 3:
        return "D"
    
    # Round 4: Feign forgiveness to confuse opponent
    if current_round == 4:
        return "C"
    
    # Mid-game: Alternate between C and D with a bias toward defection
    if 5 <= current_round <= 7:
        recent_defections = sum(1 for m in opp_history[-3:] if m == "D")
        if recent_defections > 1:
            return "D"
        else:
            return "C" if current_round % 2 == 0 else "D"
    
    # Late rounds: Aggressive stance unless opponent is consistently cooperative
    if current_round >= 8:
        if len(opp_history) >= 2 and all(m == "C" for m in opp_history[-2:]):
            return "C"
        else:
            return "D"
    
    # Default fallback (should never reach here)
    return "D"